/*! \file 
**********************************************************************************
*Title:                         Discretix Toolkit Certificate Handling ATP Test source file
*
* Filename:                     CERT_TLK_ATP_data.c
*
* 
* Created:                      18.03.2008
*
* \Author                       SagitB
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

#include "DX_VOS_BaseTypes.h"
#include "CERT_TLK_ATP_Defines.h"
#include "tlk_cert_types.h"
#include "CERT_TLK_ATP_data.h"


#ifndef DX_NO_TLK_SCLK_SUPPORT
#include "tlk_sclk_api_types.h"
#include "tlk_sclk_api.h"
#else
#include "tlk_cert_sclk_api_stub_types.h"
#endif

DxByte_t			TST_gCWorkspace[CERTTLK_ATP_WORKSPACE_SIZE];
DxUint32_t		    TST_gCWorkspaceSizeInBytes = CERTTLK_ATP_WORKSPACE_SIZE;

#ifndef DX_NO_TLK_SCLK_SUPPORT
    TLK_SCLK_ServiceClockDescriptor_t   TST_gServiceClockDesc;
    TLK_SCLK_ServiceClockDescriptor_t   TST_gServClkDescNonceValid;
#else
    TLK_SCLK_ServiceClockDescriptor_t  *TST_gServiceClockDesc;
    TLK_SCLK_ServiceClockDescriptor_t  *TST_gServClkDescNonceValid;
#endif

    TLK_CERT_Buffer_t                 TST_gServiceClockPwd;
    DxByte_t                          TST_gServiceClockPwdBuffer[] = {'1', '2', '3'};
    DxUint32_t                        TST_gServiceClockPwdLength   = 3;


    TLK_CERT_Buffer_t                 TST_gServClkDescNonceValidPwd;
    DxByte_t                          TST_gServClkDescNonceValidPwdBuffer[] = {'1', '2', '3'};
    DxUint32_t                        TST_gServClkDescNonceValidPwdLength   = 3;


/*chain*/
/*65 - */
DxByte_t TST_gEECertificate[] = 
{0x30,0x82,0x01,0x45,0x30,0x81,0xF0,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x41,0x30,
0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x0C,
0x31,0x0A,0x30,0x08,0x06,0x03,0x55,0x04,0x03,0x13,0x01,0x31,0x30,0x1E,0x17,0x0D,
0x30,0x38,0x30,0x35,0x31,0x32,0x30,0x39,0x35,0x33,0x34,0x30,0x5A,0x17,0x0D,0x31,
0x36,0x30,0x37,0x32,0x39,0x30,0x39,0x35,0x33,0x34,0x30,0x5A,0x30,0x0D,0x31,0x0B,
0x30,0x09,0x06,0x03,0x55,0x04,0x03,0x13,0x02,0x45,0x45,0x30,0x5C,0x30,0x0D,0x06,
0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x4B,0x00,0x30,
0x48,0x02,0x41,0x00,0xB2,0x12,0xA9,0xB3,0x87,0x86,0x39,0xD6,0x01,0xB6,0xDD,0xFB,
0x5A,0xAE,0x9A,0x29,0x34,0xF2,0x24,0x9D,0x6A,0x40,0xD1,0xA8,0x26,0x01,0xC0,0xB8,
0xA7,0x0E,0x21,0x9E,0x68,0xD0,0xB8,0xCD,0x74,0x80,0xC6,0x46,0xFE,0xDB,0x8C,0x5D,
0xE4,0xED,0xC1,0x84,0x5E,0x0D,0x97,0xC3,0x9E,0x1A,0xD2,0x34,0x07,0xDD,0x6D,0xFC,
0xB8,0x04,0x04,0x3B,0x02,0x03,0x01,0x00,0x01,0xA3,0x3C,0x30,0x3A,0x30,0x0C,0x06,
0x03,0x55,0x1D,0x13,0x04,0x05,0x30,0x03,0x02,0x01,0x00,0x30,0x0B,0x06,0x03,0x55,
0x1D,0x0F,0x04,0x04,0x03,0x02,0x03,0x08,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,
0x16,0x04,0x14,0x50,0x39,0x0E,0xE1,0x4A,0xD9,0x89,0xE9,0x86,0x90,0x71,0x2F,0xDF,
0xD0,0x7D,0xBF,0xB5,0x08,0xD1,0x8E,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,
0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x41,0x00,0x8F,0x35,0x18,0x80,0xB4,0xB7,0xE7,
0x10,0x80,0x10,0x47,0xDF,0x80,0x0F,0x82,0xD1,0xE0,0xC7,0x27,0x40,0x7C,0x57,0x71,
0x8C,0xC7,0xD1,0xA7,0x01,0xAE,0xCD,0xE0,0xEC,0xD2,0x8F,0x14,0x26,0x84,0xE9,0x21,
0xEE,0x75,0xD5,0xCD,0xC8,0xB6,0xE9,0x0B,0xBF,0x99,0x75,0x12,0x2A,0x75,0xD5,0xD3,
0x78,0x3A,0x3B,0x8B,0xC1,0xB1,0xD3,0x57,0x0D};
DxUint32_t TST_gEECertificateSize =329;
/*66*/
DxByte_t TST_g1Certificate[] = 
{0x30,0x82,0x01,0x67,0x30,0x82,0x01,0x11,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x42,
0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,
0x0C,0x31,0x0A,0x30,0x08,0x06,0x03,0x55,0x04,0x03,0x13,0x01,0x32,0x30,0x1E,0x17,
0x0D,0x30,0x38,0x30,0x35,0x31,0x32,0x30,0x39,0x35,0x33,0x34,0x30,0x5A,0x17,0x0D,
0x31,0x36,0x30,0x37,0x32,0x39,0x30,0x39,0x35,0x33,0x34,0x30,0x5A,0x30,0x0C,0x31,
0x0A,0x30,0x08,0x06,0x03,0x55,0x04,0x03,0x13,0x01,0x31,0x30,0x5A,0x30,0x0D,0x06,
0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x49,0x00,0x30,
0x46,0x02,0x41,0x00,0xDD,0xB6,0x58,0xD5,0x1F,0x27,0x90,0x98,0xD9,0x04,0x15,0x7C,
0x9F,0x6E,0x82,0x73,0x6D,0x17,0xE6,0x61,0x8D,0xEB,0xFA,0x08,0x62,0x04,0xE8,0xB3,
0x54,0x5D,0xD0,0x2E,0x6D,0xB9,0xEF,0x79,0x54,0x82,0x10,0x8B,0x93,0x6A,0xC7,0xA4,
0x80,0x31,0xCC,0x69,0x6B,0xE9,0x02,0xE7,0xF5,0x3E,0x5D,0x8B,0x06,0xB1,0x59,0xA8,
0xD5,0x96,0xD7,0x6F,0x02,0x01,0x03,0xA3,0x60,0x30,0x5E,0x30,0x0F,0x06,0x03,0x55,
0x1D,0x13,0x04,0x08,0x30,0x06,0x01,0x01,0xFF,0x02,0x01,0x01,0x30,0x1D,0x06,0x03,
0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0xB8,0x01,0x1B,0x85,0x5B,0x29,0x20,0xD9,0xAF,
0x86,0xFE,0xCD,0x28,0xE0,0x2A,0x55,0x83,0x2B,0xF9,0xF6,0x30,0x1F,0x06,0x03,0x55,
0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x48,0x42,0xCD,0xE6,0x6B,0xE2,0xC5,0x5B,
0x2D,0x52,0xA9,0xE7,0x03,0xBA,0xB9,0x6E,0x2A,0x73,0x38,0x4A,0x30,0x0B,0x06,0x03,
0x55,0x1D,0x0F,0x04,0x04,0x03,0x02,0x02,0x04,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,
0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x41,0x00,0x8B,0xC2,0x27,0x4F,0xD7,
0x4B,0x7A,0x68,0x7B,0x9F,0xB5,0xB0,0x34,0xD1,0xFC,0x89,0xB5,0x49,0xDD,0x74,0x08,
0x4D,0x14,0xF8,0x07,0xBD,0xB0,0xEC,0x28,0x9A,0x46,0x25,0x6A,0x25,0xE8,0xA4,0xAD,
0xB2,0x4C,0xAB,0xE1,0xA8,0x3B,0xBD,0x8E,0xB6,0xFF,0x5B,0xE9,0xD3,0x9F,0x00,0x2C,
0x39,0x12,0x5E,0x71,0x22,0x13,0xF5,0x37,0xA6,0xB5,0xFA};
DxUint32_t TST_g1CertificateSize = 363;
/*67*/
DxByte_t TST_g2Certificate[] =
{0x30,0x82,0x02,0x41,0x30,0x82,0x01,0x29,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x43,
0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,
0x0D,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x03,0x13,0x02,0x54,0x52,0x30,0x1E,
0x17,0x0D,0x30,0x38,0x30,0x35,0x31,0x32,0x30,0x39,0x35,0x33,0x34,0x30,0x5A,0x17,
0x0D,0x31,0x36,0x30,0x37,0x32,0x39,0x30,0x39,0x35,0x33,0x34,0x30,0x5A,0x30,0x0C,
0x31,0x0A,0x30,0x08,0x06,0x03,0x55,0x04,0x03,0x13,0x01,0x32,0x30,0x5C,0x30,0x0D,
0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x4B,0x00,
0x30,0x48,0x02,0x41,0x00,0xC8,0x75,0x65,0xAB,0xF4,0x47,0x44,0x12,0x2A,0xAC,0x03,
0x4F,0x27,0xD8,0x29,0x89,0xCC,0x5A,0xE9,0xB8,0x38,0xE8,0xFB,0xEE,0x17,0xC9,0x8F,
0xB2,0xEC,0x1D,0xA0,0x53,0x48,0x3E,0x62,0x74,0x6B,0xB9,0x47,0x9F,0x8C,0x7C,0xA6,
0xA9,0x8E,0x58,0xAD,0xD1,0x2D,0x3B,0x82,0xE0,0xE6,0x8F,0x9B,0xB9,0x9F,0x5B,0x07,
0x88,0xD2,0x93,0x0D,0x8D,0x02,0x03,0x01,0x00,0x01,0xA3,0x75,0x30,0x73,0x30,0x0F,
0x06,0x03,0x55,0x1D,0x13,0x04,0x08,0x30,0x06,0x01,0x01,0xFF,0x02,0x01,0x02,0x30,
0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,0x48,0x42,0xCD,0xE6,0x6B,0xE2,
0xC5,0x5B,0x2D,0x52,0xA9,0xE7,0x03,0xBA,0xB9,0x6E,0x2A,0x73,0x38,0x4A,0x30,0x1F,
0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,0x14,0x67,0x2F,0x2C,0xD5,0x5F,
0x1D,0xAB,0xCC,0x5E,0x16,0x72,0x70,0x91,0x88,0xD5,0x7E,0x1D,0x45,0x41,0x77,0x30,
0x13,0x06,0x03,0x55,0x1D,0x25,0x04,0x0C,0x30,0x0A,0x06,0x08,0x2B,0x06,0x01,0x05,
0x05,0x07,0x03,0x09,0x30,0x0B,0x06,0x03,0x55,0x1D,0x0F,0x04,0x04,0x03,0x02,0x02,
0x04,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,
0x03,0x82,0x01,0x01,0x00,0x49,0xD2,0x09,0x7A,0xAB,0xBE,0x02,0xBA,0x7C,0x4E,0x70,
0xD9,0x36,0xD0,0xFD,0x34,0x87,0x00,0x6F,0xCC,0x3C,0xE9,0xEE,0xE8,0x3E,0xD6,0xCF,
0x6A,0x3D,0xA4,0xF2,0x63,0x63,0xA3,0x2E,0xF0,0x4C,0xD2,0xFB,0xED,0xCA,0x23,0xE4,
0x5C,0xF6,0x4C,0xE6,0x3F,0x78,0x39,0xFF,0x0A,0x21,0x80,0xF5,0x3B,0x0A,0x17,0x53,
0xDC,0x43,0xB4,0x25,0xD4,0x5C,0xA8,0x6B,0x15,0x47,0xAC,0xAA,0x5D,0x22,0x87,0xC9,
0x58,0x71,0x65,0xF2,0xF5,0x64,0x42,0x6B,0x98,0x54,0x62,0x55,0x23,0x70,0x51,0xCF,
0x86,0x26,0x2E,0xB4,0x6F,0x4C,0xF4,0xBE,0xB6,0xF5,0x4C,0xE3,0x09,0x46,0x20,0x90,
0xA9,0xE1,0x37,0xB5,0x40,0xC2,0x27,0x03,0xA0,0x44,0xAE,0x7C,0xBC,0x69,0x2D,0xAD,
0xC9,0x4F,0xF3,0xAD,0xC7,0xC1,0x49,0xBC,0x63,0x87,0x68,0xD5,0x4B,0xE7,0xCD,0xE0,
0x99,0xA3,0xE8,0xCA,0x4E,0xF2,0x12,0x46,0xC4,0x31,0xBE,0x35,0x46,0x17,0xC3,0x7C,
0xC0,0x9D,0xE4,0x54,0xC3,0x20,0xFD,0xC1,0xDC,0x0D,0xCD,0x4E,0xA4,0x8E,0xB5,0x12,
0x5F,0x7D,0x9D,0x8C,0xDB,0x43,0x01,0x6F,0xD0,0xD2,0x8B,0xA4,0x62,0xD0,0xDB,0x0C,
0xD2,0x20,0x39,0xE0,0x3D,0x79,0xDD,0xE3,0x84,0xFE,0x64,0xBE,0x37,0x7F,0x2E,0xE5,
0x69,0x0A,0xD8,0xD6,0x08,0x74,0x63,0x79,0x39,0x2D,0x21,0x73,0xF2,0xFA,0x3F,0x18,
0xE5,0x6A,0x9F,0xE0,0x3D,0x9C,0xC2,0xE8,0x33,0x1E,0x66,0xC9,0xB4,0x61,0xDE,0xD9,
0x0B,0x15,0x5A,0xC8,0x64,0x32,0x31,0x56,0xC9,0x89,0xE0,0x38,0xED,0x71,0x43,0xD6,
0x2D,0x9D,0xDC,0x7A,0xC6};
DxUint32_t TST_g2CertificateSize = 581;
/*68*/
DxByte_t TST_gTRCertificate[] =
{0x30,0x82,0x02,0xF3,0x30,0x82,0x01,0xDB,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x44,
0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,
0x0D,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x03,0x13,0x02,0x54,0x52,0x30,0x1E,
0x17,0x0D,0x30,0x38,0x30,0x35,0x31,0x32,0x30,0x39,0x35,0x33,0x33,0x39,0x5A,0x17,
0x0D,0x31,0x36,0x30,0x37,0x32,0x39,0x30,0x39,0x35,0x33,0x33,0x39,0x5A,0x30,0x0D,
0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x03,0x13,0x02,0x54,0x52,0x30,0x82,0x01,
0x20,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,
0x03,0x82,0x01,0x0D,0x00,0x30,0x82,0x01,0x08,0x02,0x82,0x01,0x01,0x00,0xB4,0xAB,
0x8B,0x44,0xA8,0xA9,0x74,0x24,0xA5,0xF5,0x89,0x8A,0x7F,0x19,0x04,0xE5,0x02,0xBD,
0x26,0x89,0xBE,0xF4,0x54,0x7F,0xE0,0x83,0xB3,0x22,0x4D,0x61,0x0D,0xDE,0xCF,0x46,
0x31,0x2F,0x63,0x93,0x44,0xDF,0xDD,0xE0,0x0E,0xB0,0xC3,0x9C,0x25,0xD1,0x86,0x8E,
0x9D,0xD4,0x95,0x62,0x9F,0x70,0x0F,0x78,0x70,0xDE,0xB2,0x65,0x37,0x69,0xF4,0xE4,
0x8D,0x44,0x3D,0x39,0xF6,0x99,0xC7,0x5D,0x93,0xC4,0x66,0x32,0x89,0x51,0x11,0x3B,
0x67,0x04,0xB1,0x5B,0x2E,0x8C,0xD3,0x95,0x15,0xA4,0x33,0x35,0xF6,0x07,0x16,0x17,
0xAF,0x46,0xEB,0x7C,0x36,0xB0,0x62,0xB0,0x09,0x1E,0x3E,0xC0,0x8B,0xF8,0xCC,0x40,
0x2E,0x92,0x02,0x35,0x68,0x16,0x21,0x35,0x4C,0x4B,0xA7,0xD3,0x1B,0x2B,0xAC,0x55,
0xAD,0x89,0xC4,0xDA,0x65,0xFD,0xDC,0x30,0x07,0x54,0x62,0x9A,0xBA,0xFE,0x5C,0x85,
0xC2,0x5C,0x84,0x04,0xD6,0x03,0x9E,0x0A,0x9F,0xEF,0xDA,0xE7,0x8F,0x4A,0x9E,0xFC,
0xC2,0x27,0x0E,0x59,0x75,0xC0,0xF9,0x48,0xD1,0x53,0x06,0xB1,0x10,0xC5,0x62,0x7C,
0xFC,0x14,0x06,0xC0,0x67,0x76,0x1E,0x7E,0x60,0x13,0xA4,0x01,0xA8,0xA2,0x29,0xA8,
0x6B,0x5F,0x8C,0x99,0x74,0x87,0x8C,0x1C,0x8B,0xD0,0x41,0xFF,0x1C,0x38,0x1C,0x12,
0x7E,0x6E,0xD6,0xAB,0x89,0x2C,0x3B,0x44,0x1C,0x84,0x15,0x30,0x8A,0xAC,0x27,0xA1,
0xE4,0xD0,0xAE,0xBC,0x0F,0xE6,0xDA,0x8F,0x48,0x76,0x50,0x70,0xC4,0x0F,0xE2,0xAB,
0xA5,0xDE,0x84,0xCE,0xAF,0xC0,0x48,0x63,0xAF,0xBE,0x07,0x07,0xCF,0x3D,0x02,0x01,
0x03,0xA3,0x60,0x30,0x5E,0x30,0x0F,0x06,0x03,0x55,0x1D,0x13,0x04,0x08,0x30,0x06,
0x01,0x01,0xFF,0x02,0x01,0x03,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,
0x14,0x67,0x2F,0x2C,0xD5,0x5F,0x1D,0xAB,0xCC,0x5E,0x16,0x72,0x70,0x91,0x88,0xD5,
0x7E,0x1D,0x45,0x41,0x77,0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,
0x80,0x14,0x67,0x2F,0x2C,0xD5,0x5F,0x1D,0xAB,0xCC,0x5E,0x16,0x72,0x70,0x91,0x88,
0xD5,0x7E,0x1D,0x45,0x41,0x77,0x30,0x0B,0x06,0x03,0x55,0x1D,0x0F,0x04,0x04,0x03,
0x02,0x02,0x04,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,
0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x15,0xAF,0x8A,0x74,0x05,0xFA,0x86,0xAF,0xF6,
0xE2,0x55,0x38,0x09,0xB4,0x8F,0xE3,0xD8,0x88,0x9F,0x84,0xF9,0xD3,0xCC,0x7D,0xCA,
0x09,0x18,0x04,0xFE,0xBF,0xAF,0x00,0xE2,0x68,0x1D,0xA8,0xD4,0x87,0x7B,0x75,0x81,
0x53,0x06,0x93,0xB5,0x59,0xCD,0x90,0x2C,0x43,0xBA,0x6F,0x40,0x0D,0xEE,0x2F,0x2B,
0x4F,0x95,0x65,0x31,0x27,0x9D,0x51,0xC2,0xF8,0x73,0x2D,0x6D,0x7B,0x12,0x05,0x21,
0x34,0x8A,0x5C,0xA1,0x54,0x20,0x73,0x69,0xF9,0x60,0x9B,0xEC,0xC9,0xDA,0x61,0x66,
0x85,0xB7,0x83,0x2B,0xF6,0x18,0x08,0x4C,0x90,0xD4,0x89,0x6B,0xD8,0x15,0x3C,0x33,
0x45,0x6B,0x46,0xDD,0x22,0xBD,0xC6,0x00,0x50,0xA1,0x67,0x71,0x4B,0x45,0x66,0x16,
0x42,0xED,0xF0,0xB3,0xD4,0xD8,0xDF,0xBE,0x0F,0x58,0x28,0xAA,0x18,0xFB,0x92,0xE6,
0x89,0x8A,0xC3,0x87,0x47,0x0B,0x39,0xBF,0xF5,0xF7,0x2B,0x43,0xE6,0x79,0x48,0xCB,
0x18,0x27,0x08,0x25,0x9F,0x0E,0xF6,0x12,0xD8,0x5F,0x75,0x39,0xA1,0x1B,0xD6,0xAA,
0xEB,0x9A,0x4A,0xB6,0xED,0xA4,0x01,0x11,0x75,0x98,0x17,0x02,0x55,0xDF,0x7C,0xCE,
0x7D,0xD4,0xCA,0x3E,0xE6,0x28,0xEB,0xCF,0x0A,0xFD,0xD6,0x82,0xD5,0x77,0x3C,0x7A,
0x52,0x5C,0x67,0x3B,0x88,0xEF,0xE6,0xB9,0x96,0x9E,0xD3,0x3A,0xD0,0xB2,0x97,0xE5,
0x6B,0xDD,0x9C,0xFA,0x46,0xFB,0xBA,0xEA,0x86,0x80,0x90,0x21,0x19,0x1C,0x76,0xB4,
0xB0,0x7A,0x9B,0xB6,0x1D,0x1A,0x12,0x0D,0xAC,0xA2,0x1E,0x5D,0xA3,0x17,0x26,0xC2,
0x5D,0xAA,0x45,0x4D,0xA5,0xD6,0x4F};
DxUint32_t TST_gTRCertificateSize = 759;

/*Name ::= CHOICE {
  RDNSequence }
RDNSequence ::= SEQUENCE OF RelativeDistinguishedName
RelativeDistinguishedName ::=
SET OF AttributeTypeAndValue
AttributeTypeAndValue ::= SEQUENCE {
  type     AttributeType,
    value    AttributeValue }
AttributeType ::= OBJECT IDENTIFIER
AttributeValue ::= ANY DEFINED BY AttributeType*/
TLK_CERT_BufferOffest_t TST_gSubjectNameEE = {15,76};
TLK_CERT_BufferOffest_t TST_gIssuerNameEE = {14,30};

/*signatureValue       BIT STRING  */
TLK_CERT_BufferOffest_t TST_gSignatureTR = {261,498};

/*Validity ::= SEQUENCE {
  notBefore      Time,
   notAfter       Time }*/
                                                
DxGeneralizedTime_t     TST_gValidNotBeforeEE = {0x32,0x30,0x30, 0x38, 0x30, 0x35, 0x31, 0x32, 0x30, 0x39, 0x35, 0x33, 0x34, 0x30, 0x5A };
DxGeneralizedTime_t     TST_gValidNotAfterEE =  {0x32,0x30,0x31, 0x36, 0x30, 0x37, 0x32, 0x39, 0x30, 0x39, 0x35, 0x33, 0x34, 0x30, 0x5A }; 
/*id-ce-subjectKeyIdentifier OBJECT IDENTIFIER ::=  { id-ce 14 }*/
TLK_CERT_BufferOffest_t          TST_gSubjectKeyIdentifierEE = {31,216}; 
DxSha1Result_t  TST_gCertificateId =              { 0x50, 0x39, 0x0E, 0xE1, 0x4A, 0xD9, 0x89, 0xE9, 0x86, 0x90,
                                                   0x71, 0x2F, 0xDF, 0xD0, 0x7D, 0xBF, 0xB5, 0x08, 0xD1, 0x8E};
TLK_CERT_BufferOffest_t TST_gSubjectPublicKeyInfoEE =  {94,91};
TLK_CERT_BufferOffest_t TST_gSubjectPublicKeyInfoModulus = {0x40,0x74};
TLK_CERT_BufferOffest_t TST_gSubjectPublicKeyInfoExponent = {0x3,0xB6};
TLK_CERT_BufferOffest_t TST_gKeyUsageEE = {13,203};
TLK_CERT_BufferOffest_t TST_gSubjectNameTR = {15,78};
TLK_CERT_BufferOffest_t TST_gsubjectKeyIdentifierTR = {31,406};
TLK_CERT_BufferOffest_t TST_gSubjectPublicKeyInfoTR = {292,93};


/*OCSP*/

/* The id of the certificate to be checked*/
DxSha1Result_t          TST_gCertIdentityTBC =  { 0xa2, 0x34, 0xaf, 0x44, 0x38, 0xb1, 0x05, 0x06, 0x6b, 0x77, 
                                                 0xb9, 0xa0, 0x3f, 0xd2, 0x78, 0xcd, 0xdc, 0xa5, 0xb5, 0x26};

/*status of the verified response - successful OCSP Status - 0*/
DxUint32_t TST_gResStatus = 0;

/*The time at which the OCSP responder signed the response */
DxGeneralizedTime_t   TST_gProducedAtOfResOnTbcWithNonce        = {0x32, 0x30, 0x30, 0x39, 0x30, 0x33, 0x33, 0x30, 
                                                                   0x30, 0x38, 0x32, 0x33, 0x33, 0x39, 0x5A};
DxGeneralizedTime_t   TST_gProducedAtOfTST_gResOnTbcWithNoNonce = {0x32, 0x30, 0x30, 0x38, 0x30, 0x36, 0x30, 0x31, 0x31, 0x32, 0x32, 0x36, 0x34, 0x32, 0x5A};

/*The status of certificate to be checked*/
DxUint32_t    TST_gCertStatus = 0;            




DxByte_t TST_gExtractedCertificte[581]; 
DxUint32_t TST_gExtractedCertificteSize = 581;


DxUint8_t	TST_ga67RSAPrivateKey[1190] = {
  0x30,0x82,0x01,0x3A,0x02,0x01,0x00,0x02,0x41,0x00,0xC8,0x75,0x65,0xAB,0xF4,0x47,
  0x44,0x12,0x2A,0xAC,0x03,0x4F,0x27,0xD8,0x29,0x89,0xCC,0x5A,0xE9,0xB8,0x38,0xE8,
  0xFB,0xEE,0x17,0xC9,0x8F,0xB2,0xEC,0x1D,0xA0,0x53,0x48,0x3E,0x62,0x74,0x6B,0xB9,
  0x47,0x9F,0x8C,0x7C,0xA6,0xA9,0x8E,0x58,0xAD,0xD1,0x2D,0x3B,0x82,0xE0,0xE6,0x8F,
  0x9B,0xB9,0x9F,0x5B,0x07,0x88,0xD2,0x93,0x0D,0x8D,0x02,0x03,0x01,0x00,0x01,0x02,
  0x40,0x46,0xA0,0xEE,0x80,0xC6,0xA1,0xF1,0x7F,0x01,0x1F,0xF8,0x4E,0x84,0x78,0x6A,
  0x32,0x4E,0x19,0x5E,0x2D,0xF5,0x87,0x49,0x74,0x9B,0x56,0xFE,0x55,0x89,0x51,0xEA,
  0xF1,0xAD,0x64,0xC1,0x52,0x37,0xDA,0x65,0x9E,0xA1,0x1F,0x29,0x32,0x44,0x23,0x03,
  0x3F,0x2D,0x78,0x24,0xF0,0x49,0x7A,0x11,0xB6,0x70,0x49,0x64,0xB5,0xF2,0xD7,0xAA,
  0x01,0x02,0x21,0x00,0xE5,0xF6,0x9A,0x22,0x30,0x4E,0x16,0x86,0xED,0xCC,0xDD,0xA6,
  0x1C,0x92,0xC6,0x82,0x32,0x34,0xFE,0x38,0xB4,0xC3,0xD9,0xB8,0x4C,0x23,0x8E,0x91,
  0xCF,0xEB,0xB1,0x0D,0x02,0x21,0x00,0xDF,0x27,0x9C,0xC8,0xD8,0x6B,0x7F,0x39,0x12,
  0xB8,0x95,0x9C,0x83,0x54,0xC2,0xC6,0xB2,0x4E,0x19,0x82,0xF8,0xE8,0x23,0x29,0x89,
  0x3B,0x79,0x8C,0x76,0x58,0xAE,0x81,0x02,0x20,0x14,0x8F,0x06,0x5A,0x96,0x1C,0xF5,
  0x10,0x9D,0x03,0xDA,0xB0,0xF6,0x0E,0xFD,0x26,0x38,0x9C,0xDA,0x39,0x71,0x97,0xAC,
  0xC8,0x38,0x2E,0x59,0x99,0x99,0x90,0x05,0xA5,0x02,0x20,0x03,0xDF,0x1B,0x10,0x3C,
  0xF8,0xF8,0x77,0x14,0x05,0x11,0xCB,0x6A,0x57,0xE1,0x1D,0x33,0x60,0xB9,0x7E,0x95,
  0x34,0xE9,0xCF,0x41,0xAB,0x3F,0x7B,0x99,0x5E,0x06,0x81,0x02,0x21,0x00,0x87,0x35,
  0xF1,0xBA,0x45,0x77,0xF5,0xBC,0x5F,0x0B,0x7C,0x4B,0x9A,0x8A,0x41,0x8E,0x3B,0xBC,
  0x68,0x73,0xD3,0x42,0xA2,0xE2,0x84,0x19,0x99,0x70,0x7A,0x38,0x21,0xD4};
  DxUint32_t	TST_ga67RSAPrivateKeyDataLength = 318;


/* certificate to checked*/
DxByte_t TST_gTBCCertificte[]=
   {0x30,0x82,0x01,0xC9,0x30,0x81,0xB2,0xA0,0x03,0x02,0x01,0x02,0x02,0x01,0x28,0x30,
    0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x30,0x0D,
    0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x03,0x13,0x02,0x54,0x52,0x30,0x1E,0x17,
    0x0D,0x30,0x38,0x30,0x36,0x30,0x31,0x30,0x38,0x34,0x32,0x33,0x34,0x5A,0x17,0x0D,
    0x31,0x36,0x30,0x38,0x31,0x38,0x30,0x38,0x34,0x32,0x33,0x34,0x5A,0x30,0x0E,0x31,
    0x0C,0x30,0x0A,0x06,0x03,0x55,0x04,0x03,0x13,0x03,0x54,0x42,0x43,0x30,0x5A,0x30,
    0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x01,0x05,0x00,0x03,0x49,
    0x00,0x30,0x46,0x02,0x41,0x00,0xC4,0xB6,0x06,0xBF,0x69,0xC9,0x82,0x88,0xD0,0x54,
    0xDF,0x78,0x11,0xE7,0x5D,0xF2,0xFF,0x2C,0x7C,0x2F,0xED,0x82,0x74,0xE2,0x02,0x8D,
    0xA0,0xC2,0x17,0xF6,0xBD,0x26,0x5F,0xE7,0xF2,0x11,0x54,0xA7,0x04,0x7C,0xA8,0x6B,
    0x70,0x61,0xD9,0x5F,0x07,0xA8,0x3C,0xE2,0x2A,0x3E,0x20,0x03,0x3C,0x44,0x04,0x0E,
    0x65,0x52,0x7A,0x76,0x88,0xE5,0x02,0x01,0x03,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,
    0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x8B,0xB3,0x48,
    0xD1,0x4A,0xA8,0x65,0x14,0x1A,0x36,0x6B,0xCC,0x5F,0x89,0x41,0xEC,0x92,0x06,0x81,
    0xDB,0xFF,0x09,0x81,0x1A,0x9A,0xAC,0x23,0x3E,0x04,0xB8,0x65,0x48,0x0C,0xD0,0xE7,
    0x25,0x46,0xAA,0xDF,0xE3,0xBB,0x10,0x05,0x2B,0xD8,0xFD,0xC0,0xE8,0x8F,0xEE,0x17,
    0x5D,0x64,0xA5,0x96,0x99,0x71,0x08,0x38,0x7E,0x3A,0x73,0x58,0x95,0x47,0xE2,0x2E,
    0x9F,0x58,0x9A,0x5E,0x46,0x06,0x76,0x73,0x17,0x61,0x5A,0xFD,0x64,0x43,0xD9,0x96,
    0x35,0xAA,0x5C,0x09,0x5B,0x75,0x59,0xE9,0x2D,0x38,0x96,0x12,0x69,0x78,0xF4,0x15,
    0x74,0x86,0x2F,0x6A,0x10,0x59,0x63,0x7A,0xD1,0x20,0xEA,0x10,0xAD,0xB7,0xA9,0x63,
    0x69,0xD9,0x5B,0xB8,0xC5,0xF1,0x8B,0x3C,0x12,0xB1,0x55,0xAB,0x58,0xEC,0xA9,0x31,
    0x88,0xEC,0x74,0x84,0x91,0x1C,0xE5,0xD7,0xE2,0x66,0x39,0x34,0x4D,0xC4,0x48,0x96,
    0xFE,0x51,0x02,0xB6,0x42,0xE4,0xF2,0x75,0xC7,0x2C,0x5C,0x63,0xE7,0xDB,0xF5,0x8A,
    0x1D,0xB7,0xCB,0x8D,0xDA,0x2F,0xA5,0x5C,0xD2,0xF9,0xCE,0x67,0xB8,0x96,0xE5,0x6B,
    0xA7,0x52,0x9F,0xB2,0x85,0x7A,0x49,0xA1,0x75,0x64,0xB9,0xBD,0xA5,0x10,0x7A,0x70,
    0xDE,0x47,0x1D,0xB5,0x42,0xEE,0x76,0xCB,0xC7,0x28,0x82,0x55,0xDE,0x8B,0x5E,0x24,
    0xF3,0xBC,0x51,0xB1,0x64,0xC9,0xC7,0x71,0x76,0x99,0x36,0x94,0xC4,0x27,0xB2,0xBC,
    0x2A,0xC5,0x43,0xA8,0x60,0x1A,0xAE,0x6F,0xF1,0xD2,0xE8,0x18,0xA4,0x57,0xFB,0xE7,
    0x76,0xC0,0x19,0xED,0x3C,0x4E,0x5D,0x1A,0xE1,0x63,0x6D,0x75,0x4B};

DxUint32_t TST_gTBCCertificteSize = 461;
/* In the response: certificate to be checked  - TST_gTBCCertificte, its CA certificate  is  TST_gTRCertificate*/
/* Responder certificate  - TST_g2Certificate */
DxByte_t TST_gResOnTbcWithNonce[] = 
{
    0x30, 0x82, 0x03, 0x6C, 0x0A, 0x01, 0x00, 0xA0, 0x82, 0x03, 0x65, 0x30, 0x82, 0x03, 0x61, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x30, 0x01, 0x01, 0x04, 0x82, 0x03, 0x52, 0x30, 0x82, 0x03, 0x4E, 0x30, 0x81, 0xAC, 0xA1, 0x0E, 0x30, 0x0C, 0x31, 0x0A, 0x30, 0x08, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x01, 0x32, 0x18, 0x0F, 0x32, 0x30, 0x30, 0x39, 0x30, 0x33, 0x33, 0x30, 0x30, 0x38, 0x32, 0x33, 0x33, 0x39, 0x5A, 0x30, 0x64, 0x30, 0x62, 0x30, 0x3A, 0x30, 0x09, 0x06, 0x05, 0x2B, 0x0E, 0x03, 0x02, 0x1A, 0x05, 0x00, 0x04, 0x14, 0x27, 0xB6, 0x6A, 0xB5, 0xBA, 0x75, 0xEA, 0x24, 0x95, 0xFA, 0x22, 0xC1, 0xB0, 0x47, 0xE0, 0xDF, 0xA8, 0x2F, 0x05, 0xDF, 0x04, 0x14, 0x67, 0x2F, 0x2C, 0xD5, 0x5F, 0x1D, 0xAB, 0xCC, 0x5E, 0x16, 0x72, 0x70, 0x91, 0x88, 0xD5, 0x7E, 0x1D, 0x45, 0x41, 0x77, 0x02, 0x01, 0x28, 0x80, 0x00, 0x18, 0x0F, 0x32, 0x30, 0x30, 0x39, 0x30, 0x33, 0x33, 0x30, 0x31, 0x31, 0x32, 0x31, 0x35, 0x31, 0x5A, 0xA0, 0x11, 0x18, 0x0F, 0x32, 0x30, 0x31, 0x34, 0x30, 0x33, 0x32, 0x38, 0x31, 0x31, 0x32, 0x31, 0x35, 0x31, 0x5A, 0xA1, 0x23, 0x30, 0x21, 0x30, 0x1F, 0x06, 0x09, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x30, 0x01, 0x02, 0x04, 0x12, 0x04, 0x10, 0x8A, 0xA2, 0x23, 0xB6, 0x74, 0x62, 0x57, 0xC8, 0x5A, 0x5F, 0x13, 0xEA, 0x14, 0xE8, 0xA1, 0x78, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x41, 0x00, 0x11, 0x0A, 0x9E, 0xE2, 0x15, 0x88, 0x16, 0xF3, 0x75, 0xAA, 0xE1, 0xFD, 0x62, 0x06, 0x8D, 0x44, 0x23, 0xAB, 0x3D, 0xD6, 0xE0, 0xC7, 0xCD, 0xF1, 0xFC, 0x38, 0x8D, 0xB7, 0x98, 0x9F, 0x3B, 0x2D, 0x04, 0xF7, 0xE9, 0xAD, 0xC8, 0xCC, 0x01, 0xE9, 0x6D, 0xC6, 0xFF, 0x78, 0x7D, 0x77, 0x0E, 0xD0, 0x3F, 0xBB, 0x38, 0xAD, 0x30, 0x8E, 0x56, 0xEB, 0xCE, 0x3E, 0xF7, 0x38, 0x66, 0xB0, 0x04, 0xB6, 0xA0, 0x82, 0x02, 0x49, 0x30, 0x82, 0x02, 0x45, 0x30, 0x82, 0x02, 0x41, 0x30, 0x82, 0x01, 0x29, 0xA0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x01, 0x43, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x30, 0x0D, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x02, 0x54, 0x52, 0x30, 0x1E, 0x17, 0x0D, 0x30, 0x38, 0x30, 0x35, 0x31, 0x32, 0x30, 0x39, 0x35, 0x33, 0x34, 0x30, 0x5A, 0x17, 0x0D, 0x31, 0x36, 0x30, 0x37, 0x32, 0x39, 0x30, 0x39, 0x35, 0x33, 0x34, 0x30, 0x5A, 0x30, 0x0C, 0x31, 0x0A, 0x30, 0x08, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x01, 0x32, 0x30, 0x5C, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x4B, 0x00, 0x30, 0x48, 0x02, 0x41, 0x00, 0xC8, 0x75, 0x65, 0xAB, 0xF4, 0x47, 0x44, 0x12, 0x2A, 0xAC, 0x03, 0x4F, 0x27, 0xD8, 0x29, 0x89, 0xCC, 0x5A, 0xE9, 0xB8, 0x38, 0xE8, 0xFB, 0xEE, 0x17, 0xC9, 0x8F, 0xB2, 0xEC, 0x1D, 0xA0, 0x53, 0x48, 0x3E, 0x62, 0x74, 0x6B, 0xB9, 0x47, 0x9F, 0x8C, 0x7C, 0xA6, 0xA9, 0x8E, 0x58, 0xAD, 0xD1, 0x2D, 0x3B, 0x82, 0xE0, 0xE6, 0x8F, 0x9B, 0xB9, 0x9F, 0x5B, 0x07, 0x88, 0xD2, 0x93, 0x0D, 0x8D, 0x02, 0x03, 0x01, 0x00, 0x01, 0xA3, 0x75, 0x30, 0x73, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xFF, 0x02, 0x01, 0x02, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0x48, 0x42, 0xCD, 0xE6, 0x6B, 0xE2, 0xC5, 0x5B, 0x2D, 0x52, 0xA9, 0xE7, 0x03, 0xBA, 0xB9, 0x6E, 0x2A, 0x73, 0x38, 0x4A, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x67, 0x2F, 0x2C, 0xD5, 0x5F, 0x1D, 0xAB, 0xCC, 0x5E, 0x16, 0x72, 0x70, 0x91, 0x88, 0xD5, 0x7E, 0x1D, 0x45, 0x41, 0x77, 0x30, 0x13, 0x06, 0x03, 0x55, 0x1D, 0x25, 0x04, 0x0C, 0x30, 0x0A, 0x06, 0x08, 0x2B, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x09, 0x30, 0x0B, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x04, 0x04, 0x03, 0x02, 0x02, 0x04, 0x30, 0x0D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x01, 0x05, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x49, 0xD2, 0x09, 0x7A, 0xAB, 0xBE, 0x02, 0xBA, 0x7C, 0x4E, 0x70, 0xD9, 0x36, 0xD0, 0xFD, 0x34, 0x87, 0x00, 0x6F, 0xCC, 0x3C, 0xE9, 0xEE, 0xE8, 0x3E, 0xD6, 0xCF, 0x6A, 0x3D, 0xA4, 0xF2, 0x63, 0x63, 0xA3, 0x2E, 0xF0, 0x4C, 0xD2, 0xFB, 0xED, 0xCA, 0x23, 0xE4, 0x5C, 0xF6, 0x4C, 0xE6, 0x3F, 0x78, 0x39, 0xFF, 0x0A, 0x21, 0x80, 0xF5, 0x3B, 0x0A, 0x17, 0x53, 0xDC, 0x43, 0xB4, 0x25, 0xD4, 0x5C, 0xA8, 0x6B, 0x15, 0x47, 0xAC, 0xAA, 0x5D, 0x22, 0x87, 0xC9, 0x58, 0x71, 0x65, 0xF2, 0xF5, 0x64, 0x42, 0x6B, 0x98, 0x54, 0x62, 0x55, 0x23, 0x70, 0x51, 0xCF, 0x86, 0x26, 0x2E, 0xB4, 0x6F, 0x4C, 0xF4, 0xBE, 0xB6, 0xF5, 0x4C, 0xE3, 0x09, 0x46, 0x20, 0x90, 0xA9, 0xE1, 0x37, 0xB5, 0x40, 0xC2, 0x27, 0x03, 0xA0, 0x44, 0xAE, 0x7C, 0xBC, 0x69, 0x2D, 0xAD, 0xC9, 0x4F, 0xF3, 0xAD, 0xC7, 0xC1, 0x49, 0xBC, 0x63, 0x87, 0x68, 0xD5, 0x4B, 0xE7, 0xCD, 0xE0, 0x99, 0xA3, 0xE8, 0xCA, 0x4E, 0xF2, 0x12, 0x46, 0xC4, 0x31, 0xBE, 0x35, 0x46, 0x17, 0xC3, 0x7C, 0xC0, 0x9D, 0xE4, 0x54, 0xC3, 0x20, 0xFD, 0xC1, 0xDC, 0x0D, 0xCD, 0x4E, 0xA4, 0x8E, 0xB5, 0x12, 0x5F, 0x7D, 0x9D, 0x8C, 0xDB, 0x43, 0x01, 0x6F, 0xD0, 0xD2, 0x8B, 0xA4, 0x62, 0xD0, 0xDB, 0x0C, 0xD2, 0x20, 0x39, 0xE0, 0x3D, 0x79, 0xDD, 0xE3, 0x84, 0xFE, 0x64, 0xBE, 0x37, 0x7F, 0x2E, 0xE5, 0x69, 0x0A, 0xD8, 0xD6, 0x08, 0x74, 0x63, 0x79, 0x39, 0x2D, 0x21, 0x73, 0xF2, 0xFA, 0x3F, 0x18, 0xE5, 0x6A, 0x9F, 0xE0, 0x3D, 0x9C, 0xC2, 0xE8, 0x33, 0x1E, 0x66, 0xC9, 0xB4, 0x61, 0xDE, 0xD9, 0x0B, 0x15, 0x5A, 0xC8, 0x64, 0x32, 0x31, 0x56, 0xC9, 0x89, 0xE0, 0x38, 0xED, 0x71, 0x43, 0xD6, 0x2D, 0x9D, 0xDC, 0x7A, 0xC6
};

DxUint32_t TST_gResOnTbcWithNonceSize = 0x370;

/*Response with no nonce and with a Responder certificate -*/
DxByte_t TST_gResOnTbcWithNoNonce[] = 
{0x30,0x82,0x03,0x47,0x0A,0x01,0x00,0xA0,0x82,0x03,0x40,0x30,0x82,0x03,0x3C,0x06,
 0x09,0x2B,0x06,0x01,0x05,0x05,0x07,0x30,0x01,0x01,0x04,0x82,0x03,0x2D,0x30,0x82,
 0x03,0x29,0x30,0x81,0x87,0xA1,0x0E,0x30,0x0C,0x31,0x0A,0x30,0x08,0x06,0x03,0x55,
 0x04,0x03,0x13,0x01,0x32,0x18,0x0F,0x32,0x30,0x30,0x38,0x30,0x36,0x30,0x31,0x31,
 0x32,0x32,0x36,0x34,0x32,0x5A,0x30,0x64,0x30,0x62,0x30,0x3A,0x30,0x09,0x06,0x05,
 0x2B,0x0E,0x03,0x02,0x1A,0x05,0x00,0x04,0x14,0x27,0xB6,0x6A,0xB5,0xBA,0x75,0xEA,
 0x24,0x95,0xFA,0x22,0xC1,0xB0,0x47,0xE0,0xDF,0xA8,0x2F,0x05,0xDF,0x04,0x14,0x67,
 0x2F,0x2C,0xD5,0x5F,0x1D,0xAB,0xCC,0x5E,0x16,0x72,0x70,0x91,0x88,0xD5,0x7E,0x1D,
 0x45,0x41,0x77,0x02,0x01,0x28,0x80,0x00,0x18,0x0F,0x32,0x30,0x30,0x38,0x30,0x36,
 0x30,0x31,0x31,0x35,0x31,0x38,0x31,0x32,0x5A,0xA0,0x11,0x18,0x0F,0x32,0x30,0x31,
 0x34,0x30,0x34,0x30,0x31,0x31,0x35,0x31,0x38,0x31,0x32,0x5A,0x30,0x0D,0x06,0x09,
 0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x41,0x00,0xB5,0x28,
 0x0C,0x57,0xFD,0xAA,0xDF,0xCE,0x29,0x6E,0xCD,0x4D,0x83,0xB8,0x7F,0xD1,0x3A,0xE4,
 0x79,0x86,0x58,0xF9,0x04,0xF5,0xDD,0x22,0x11,0xEF,0x41,0x96,0x1F,0x43,0x7C,0x9E,
 0xBA,0x83,0xFB,0xD4,0x12,0x49,0x16,0xFE,0x9D,0xC6,0x21,0x93,0xB2,0x77,0x49,0x07,
 0x8C,0x07,0x46,0x45,0x60,0xF9,0xBF,0xD3,0xB5,0x79,0x4D,0xD0,0x16,0xCD,0xA0,0x82,
 0x02,0x49,0x30,0x82,0x02,0x45,0x30,0x82,0x02,0x41,0x30,0x82,0x01,0x29,0xA0,0x03,
 0x02,0x01,0x02,0x02,0x01,0x43,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,
 0x01,0x01,0x05,0x05,0x00,0x30,0x0D,0x31,0x0B,0x30,0x09,0x06,0x03,0x55,0x04,0x03,
 0x13,0x02,0x54,0x52,0x30,0x1E,0x17,0x0D,0x30,0x38,0x30,0x35,0x31,0x32,0x30,0x39,
 0x35,0x33,0x34,0x30,0x5A,0x17,0x0D,0x31,0x36,0x30,0x37,0x32,0x39,0x30,0x39,0x35,
 0x33,0x34,0x30,0x5A,0x30,0x0C,0x31,0x0A,0x30,0x08,0x06,0x03,0x55,0x04,0x03,0x13,
 0x01,0x32,0x30,0x5C,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,0x0D,0x01,0x01,
 0x01,0x05,0x00,0x03,0x4B,0x00,0x30,0x48,0x02,0x41,0x00,0xC8,0x75,0x65,0xAB,0xF4,
 0x47,0x44,0x12,0x2A,0xAC,0x03,0x4F,0x27,0xD8,0x29,0x89,0xCC,0x5A,0xE9,0xB8,0x38,
 0xE8,0xFB,0xEE,0x17,0xC9,0x8F,0xB2,0xEC,0x1D,0xA0,0x53,0x48,0x3E,0x62,0x74,0x6B,
 0xB9,0x47,0x9F,0x8C,0x7C,0xA6,0xA9,0x8E,0x58,0xAD,0xD1,0x2D,0x3B,0x82,0xE0,0xE6,
 0x8F,0x9B,0xB9,0x9F,0x5B,0x07,0x88,0xD2,0x93,0x0D,0x8D,0x02,0x03,0x01,0x00,0x01,
 0xA3,0x75,0x30,0x73,0x30,0x0F,0x06,0x03,0x55,0x1D,0x13,0x04,0x08,0x30,0x06,0x01,
 0x01,0xFF,0x02,0x01,0x02,0x30,0x1D,0x06,0x03,0x55,0x1D,0x0E,0x04,0x16,0x04,0x14,
 0x48,0x42,0xCD,0xE6,0x6B,0xE2,0xC5,0x5B,0x2D,0x52,0xA9,0xE7,0x03,0xBA,0xB9,0x6E,
 0x2A,0x73,0x38,0x4A,0x30,0x1F,0x06,0x03,0x55,0x1D,0x23,0x04,0x18,0x30,0x16,0x80,
 0x14,0x67,0x2F,0x2C,0xD5,0x5F,0x1D,0xAB,0xCC,0x5E,0x16,0x72,0x70,0x91,0x88,0xD5,
 0x7E,0x1D,0x45,0x41,0x77,0x30,0x13,0x06,0x03,0x55,0x1D,0x25,0x04,0x0C,0x30,0x0A,
 0x06,0x08,0x2B,0x06,0x01,0x05,0x05,0x07,0x03,0x09,0x30,0x0B,0x06,0x03,0x55,0x1D,
 0x0F,0x04,0x04,0x03,0x02,0x02,0x04,0x30,0x0D,0x06,0x09,0x2A,0x86,0x48,0x86,0xF7,
 0x0D,0x01,0x01,0x05,0x05,0x00,0x03,0x82,0x01,0x01,0x00,0x49,0xD2,0x09,0x7A,0xAB,
 0xBE,0x02,0xBA,0x7C,0x4E,0x70,0xD9,0x36,0xD0,0xFD,0x34,0x87,0x00,0x6F,0xCC,0x3C,
 0xE9,0xEE,0xE8,0x3E,0xD6,0xCF,0x6A,0x3D,0xA4,0xF2,0x63,0x63,0xA3,0x2E,0xF0,0x4C,
 0xD2,0xFB,0xED,0xCA,0x23,0xE4,0x5C,0xF6,0x4C,0xE6,0x3F,0x78,0x39,0xFF,0x0A,0x21,
 0x80,0xF5,0x3B,0x0A,0x17,0x53,0xDC,0x43,0xB4,0x25,0xD4,0x5C,0xA8,0x6B,0x15,0x47,
 0xAC,0xAA,0x5D,0x22,0x87,0xC9,0x58,0x71,0x65,0xF2,0xF5,0x64,0x42,0x6B,0x98,0x54,
 0x62,0x55,0x23,0x70,0x51,0xCF,0x86,0x26,0x2E,0xB4,0x6F,0x4C,0xF4,0xBE,0xB6,0xF5,
 0x4C,0xE3,0x09,0x46,0x20,0x90,0xA9,0xE1,0x37,0xB5,0x40,0xC2,0x27,0x03,0xA0,0x44,
 0xAE,0x7C,0xBC,0x69,0x2D,0xAD,0xC9,0x4F,0xF3,0xAD,0xC7,0xC1,0x49,0xBC,0x63,0x87,
 0x68,0xD5,0x4B,0xE7,0xCD,0xE0,0x99,0xA3,0xE8,0xCA,0x4E,0xF2,0x12,0x46,0xC4,0x31,
 0xBE,0x35,0x46,0x17,0xC3,0x7C,0xC0,0x9D,0xE4,0x54,0xC3,0x20,0xFD,0xC1,0xDC,0x0D,
 0xCD,0x4E,0xA4,0x8E,0xB5,0x12,0x5F,0x7D,0x9D,0x8C,0xDB,0x43,0x01,0x6F,0xD0,0xD2,
 0x8B,0xA4,0x62,0xD0,0xDB,0x0C,0xD2,0x20,0x39,0xE0,0x3D,0x79,0xDD,0xE3,0x84,0xFE,
 0x64,0xBE,0x37,0x7F,0x2E,0xE5,0x69,0x0A,0xD8,0xD6,0x08,0x74,0x63,0x79,0x39,0x2D,
 0x21,0x73,0xF2,0xFA,0x3F,0x18,0xE5,0x6A,0x9F,0xE0,0x3D,0x9C,0xC2,0xE8,0x33,0x1E,
 0x66,0xC9,0xB4,0x61,0xDE,0xD9,0x0B,0x15,0x5A,0xC8,0x64,0x32,0x31,0x56,0xC9,0x89,
 0xE0,0x38,0xED,0x71,0x43,0xD6,0x2D,0x9D,0xDC,0x7A,0xC6};

DxUint32_t TST_gResOnTbcWithNoNonceSize = 843;

DxGeneralizedTime_t TST_gResOnTbcWithNoNonceNextUpdate = {0x32, 0x30, 0x31, 0x34, 0x30, 0x33, 0x32, 0x38, 0x31, 0x31, 0x32, 0x31, 0x35, 0x31, 0x5A};
DxGeneralizedTime_t TST_gResOnTbcWithNonceNextUpdate   = {0x32, 0x30, 0x30, 0x38, 0x30, 0x36, 0x30, 0x31, 0x31, 0x35, 0x31, 0x38, 0x31, 0x32, 0x5A};

/*certificate 65 hash on  Subject Public Key Info*/
 DxSha1Result_t TST_gCertIdentifier={0x5E,0xC9,0xF1,0x13,0x4D,0x70,0x61,0xB6,0x9E,0x00,0x0B,0x9F,0x26,0x41,0x55,0xA0,0x73,0xF0,0xF7,0xDF};
 
 